package com.bycom.versapro.MenuTypes.WordPress.UserInterface;

import static com.bycom.versapro.Serializables.Constant.adMobHelper;
import static com.bycom.versapro.Utils.AppUtil.getWebViewStyle;
import static com.bycom.versapro.Utils.AppUtil.launchChromeCustomTab;
import static com.bycom.versapro.Utils.PrefUtil.getTextZoom;
import static com.bycom.versapro.Utils.PrefUtil.setTextZoom;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.os.Bundle;
import android.os.Handler;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import android.text.Html;
import android.transition.Fade;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.widget.NestedScrollView;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bycom.versapro.R;
import com.bycom.versapro.Utils.AdMobHelper;
import com.bycom.versapro.Utils.PrefUtil;

import com.bycom.versapro.MenuTypes.WordPress.Adapters.WPCategoryAdapter;
import com.bycom.versapro.MenuTypes.WordPress.Adapters.WPPostAdapter;

import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.gms.ads.admanager.AdManagerAdView;
import com.google.android.material.slider.Slider;
import com.squareup.picasso.Picasso;
import com.wordpress.restapi.RESTAPI;
import com.wordpress.restapi.Serializables.WPCategory;
import com.wordpress.restapi.Serializables.WPPost;
import com.wordpress.restapi.PostFetcher;
import com.wordpress.restapi.RelatedPostURL;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;


@SuppressLint("SetJavaScriptEnabled")
public class WPPostDetailsFragment extends Fragment {

    TextToSpeech textToSpeech;
    public String transitionName;
    AppCompatActivity activity;
    WebView webView;
    ShimmerFrameLayout shimmer,content_shimmer;
    public WPPost post;
    RecyclerView rv_related,rv_categories;
    View ll_related;
    ProgressBar progress_tts;
    boolean isAnimating = true,isBookmarkRemoved = false;
    ImageView iv_tts,iv_post,iv_bookmark;
    FrameLayout fullscreenContainer;
    HashMap<Integer, WPCategory> categories = new HashMap<>();
    public Drawable drawable_post;

    NestedScrollView nestedScrollView;

    public BookmarkRemovedCallback bookmarkRemovedCallback;



    public WPPostDetailsFragment(){

    }


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_wp_post_details, container, false);

    }


    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);


        setEnterTransition(new Fade());
        setExitTransition(new Fade());




        activity = (AppCompatActivity) requireActivity();


        nestedScrollView = view.findViewById(R.id.nsv);
        TextView tv_title = view.findViewById(R.id.tv_title);
        TextView tv_date = view.findViewById(R.id.tv_date);
        iv_post = view.findViewById(R.id.iv_post);
        ImageView iv_share = view.findViewById(R.id.iv_share);
        iv_bookmark = view.findViewById(R.id.iv_bookmark);
        iv_tts = view.findViewById(R.id.iv_tts);
        rv_related = view.findViewById(R.id.rv_related);
        shimmer = view.findViewById(R.id.shimmer);
        ll_related = view.findViewById(R.id.ll_related);
        rv_categories = view.findViewById(R.id.rv_categories);
        content_shimmer = view.findViewById(R.id.content_shimmer);
        progress_tts = view.findViewById(R.id.progress_tts);



        updateBookmark(PrefUtil.isBookmarked(post));



        if(drawable_post != null){
            iv_post.setVisibility(View.VISIBLE);
            iv_post.setImageDrawable(drawable_post);
        }else iv_post.setVisibility(View.GONE);


        for (Integer categoryId : post.getCategoryIds()) {
            WPCategory category = PrefUtil.getCategory(post.getBASE_URL(),categoryId);
            if(category != null) categories.put(categoryId,category);
        }


        loadRelatedPost();
        loadCategories();

        onSpeakStopped();


        iv_bookmark.setOnClickListener(v -> updateBookmark(!PrefUtil.isBookmarked(post)));

        iv_share.setOnClickListener(v -> {
            Intent shareIntent = new Intent(Intent.ACTION_SEND);
            shareIntent.setType("text/plain");
            shareIntent.putExtra(Intent.EXTRA_TEXT, post.getLink());
            Intent chooserIntent = Intent.createChooser(shareIntent, "Share URL");
            activity.startActivity(chooserIntent);
        });


        new Handler().postDelayed(() -> isAnimating = false,500);


        iv_post.setTransitionName(transitionName);

        webView = view.findViewById(R.id.webView);


        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setVerticalScrollBarEnabled(false);
        webView.setHorizontalScrollBarEnabled(false);
        webView.getSettings().setCacheMode(WebSettings.LOAD_DEFAULT);


        webView.setBackgroundColor(Color.TRANSPARENT);


        loadBannerAdTop();


        webView.setWebChromeClient(new WebChromeClient(){

            @Override
            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
                activity.getWindow().setFlags(
                        WindowManager.LayoutParams.FLAG_FULLSCREEN,
                        WindowManager.LayoutParams.FLAG_FULLSCREEN
                );

                activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);


                fullscreenContainer = new FrameLayout(activity);
                fullscreenContainer.addView(view, new FrameLayout.LayoutParams(
                        ViewGroup.LayoutParams.MATCH_PARENT,
                        ViewGroup.LayoutParams.MATCH_PARENT
                ));

                ViewGroup decorView = (ViewGroup) activity.getWindow().getDecorView();
                decorView.addView(fullscreenContainer);



            }

            @Override
            public void onHideCustomView() {

                ViewGroup decorView = (ViewGroup) activity.getWindow().getDecorView();
                decorView.removeView(fullscreenContainer);

                fullscreenContainer = null;

                activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);
                activity.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
            }



        });

        webView.setWebViewClient(new WebViewClient() {

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);

            }





            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {

                launchChromeCustomTab(activity,request.getUrl());

                return true;
            }

        });




        Document content = Jsoup.parse(post.getContent());

        removeDuplicateIMG(content,post.getImageUrl());



        content.head().append(getWebViewStyle(activity));



        webView.loadDataWithBaseURL("file:///android_asset/", content.html(),"text/html", "UTF-8","");



        webView.getSettings().setTextZoom(getTextZoom());


        View sliderLayout = view.findViewById(R.id.slider_layout);
        Slider zoomSlider = view.findViewById(R.id.zoom_slider);

        Handler handler = new Handler();
        Runnable runnable = () -> sliderLayout.setVisibility(View.GONE);


        ScaleGestureDetector scaleGestureDetector = new ScaleGestureDetector(activity, new ScaleGestureDetector.SimpleOnScaleGestureListener() {
            @Override
            public boolean onScale(@NonNull ScaleGestureDetector detector) {
                float scaleFactor = detector.getScaleFactor();
                int currentTextSize = webView.getSettings().getTextZoom();
                float newTextSize = currentTextSize * scaleFactor;
                int minTextSize = 50;
                int maxTextSize = 300;
                newTextSize = Math.max(minTextSize, Math.min(newTextSize, maxTextSize));
                handler.removeCallbacks(runnable);
                handler.postDelayed(runnable,2000);
                zoomSlider.setValue(newTextSize);
                return true;
            }
        });

        zoomSlider.addOnChangeListener((slider, value, fromUser) -> {
            webView.getSettings().setTextZoom((int) value);
            setTextZoom((int) value);
            if (sliderLayout.getVisibility() == View.GONE) sliderLayout.setVisibility(View.VISIBLE);

        });

        zoomSlider.addOnSliderTouchListener(new Slider.OnSliderTouchListener() {
            @Override
            public void onStartTrackingTouch(@NonNull Slider slider) {
                handler.removeCallbacks(runnable);
            }
            @Override
            public void onStopTrackingTouch(@NonNull Slider slider) {
                handler.removeCallbacks(runnable);
                handler.postDelayed(runnable,2000);
            }
        });


        nestedScrollView.setOnTouchListener((v, event) -> {
            scaleGestureDetector.onTouchEvent(event);
            if (event.getAction() == MotionEvent.ACTION_UP) {
                v.performClick();
            }
            return false;
        });


        new Handler().postDelayed(() -> {
            content_shimmer.stopShimmer();
            content_shimmer.setVisibility(View.GONE);
            webView.setVisibility(View.VISIBLE);
            adMobHelper.getInterstitialAdManager().showAd(activity);
        },1000);





        tv_title.setText(post.getTitle());
        tv_date.setText(post.getPublished_date());


        if(drawable_post==null) {

            DisplayMetrics displayMetrics = activity.getResources().getDisplayMetrics();

            if (!post.getImageUrl().isEmpty()) {
                iv_post.setVisibility(View.VISIBLE);
                Picasso.get()
                        .load(post.getImageUrl())
                        .resize(displayMetrics.widthPixels, displayMetrics.heightPixels)
                        .centerInside()
                        .into(iv_post);
            } else iv_post.setVisibility(View.GONE);

        }










    }


    private void loadBannerAdTop(){
        adMobHelper.getBannerAdManager().getAnchoredAdView(activity, new AdMobHelper.BannerAdCallback() {
            @Override
            public void onSuccess(AdManagerAdView adManagerAdView) {
                RelativeLayout banner_ad_container1 = requireView().findViewById(R.id.banner_ad_container1);
                banner_ad_container1.addView(adManagerAdView);
                banner_ad_container1.setVisibility(View.VISIBLE);

                loadBannerAdBottom();
            }

            @Override
            public void onFailed() {
                loadBannerAdBottom();
            }
        });

    }


    private void loadBannerAdBottom(){
        adMobHelper.getBannerAdManager().getInlineAdView(activity, new AdMobHelper.BannerAdCallback() {
            @Override
            public void onSuccess(AdManagerAdView adManagerAdView) {
                RelativeLayout banner_ad_container2 = requireView().findViewById(R.id.banner_ad_container2);
                banner_ad_container2.addView(adManagerAdView);
                banner_ad_container2.setVisibility(View.VISIBLE);
            }
            @Override
            public void onFailed() {

            }
        });
    }



    private void updateBookmark(Boolean isChecked) {
        if (isChecked) {
            iv_bookmark.setImageResource(R.drawable.ic_bookmark_filled);
            PrefUtil.addBookmark(post);
            isBookmarkRemoved = false;
        }
        else {
            iv_bookmark.setImageResource(R.drawable.ic_bookmark);
            PrefUtil.removeBookmark(post);
            isBookmarkRemoved = true;
        }
    }

    private void loadCategories() {

        HashMap<Integer, WPCategory> post_categories = new HashMap<>();

        for (Integer categoryId : post.getCategoryIds()) {
            WPCategory category = categories.get(categoryId);
            if(category!=null) post_categories.put(categoryId,category);
        }



        LinearLayoutManager layoutManager = new LinearLayoutManager(activity, LinearLayoutManager.HORIZONTAL, false);
        rv_categories.setLayoutManager(layoutManager);


        WPCategoryAdapter adapter = new WPCategoryAdapter(activity, WPPostDetailsFragment.this, post_categories, post.getBASE_URL());
        rv_categories.setAdapter(adapter);


















    }




    private void loadRelatedPost(){


        PostFetcher.fetchPosts(RelatedPostURL.getRelatedPostURL(post.getBASE_URL(), post.getCategoryIds(),post.getPostID()), post.getBASE_URL(), WPPostAdapter.ITEM_POST, new RESTAPI.PostsCallback() {
            @Override
            public void onCompleted(ArrayList<WPPost> posts) {


                Collections.shuffle(posts);

                if (posts.size()>3) posts.subList(3, posts.size()).clear();


                activity.runOnUiThread(() -> {


                    WPPostAdapter adapter = new WPPostAdapter(activity, WPPostDetailsFragment.this,null,posts,post.getBASE_URL(),null);
                    LinearLayoutManager layoutManager = new LinearLayoutManager(activity);
                    rv_related.setLayoutManager(layoutManager);
                    rv_related.setAdapter(adapter);



                    shimmer.stopShimmer();
                    shimmer.setVisibility(View.GONE);
                });




            }

            @Override
            public void onFailed(String error) {
                activity.runOnUiThread(() -> {
                    shimmer.stopShimmer();
                    shimmer.setVisibility(View.GONE);
                    ll_related.setVisibility(View.GONE);
                });

            }
        });



    }

    private void initializeTTS(String text) {
        progress_tts.setVisibility(View.VISIBLE);
        iv_tts.setVisibility(View.GONE);

        textToSpeech = new TextToSpeech(activity, status -> {
            if (status == TextToSpeech.SUCCESS) {

                textToSpeech.setOnUtteranceProgressListener(new UtteranceProgressListener() {
                    @Override
                    public void onStart(String utteranceId) {

                        activity.runOnUiThread(() -> onSpeakStarted());

                    }

                    @Override
                    public void onDone(String utteranceId) {

                        activity.runOnUiThread(() -> onSpeakStopped());
                    }

                    @Override
                    public void onError(String utteranceId) {
                        activity.runOnUiThread(() -> {
                            Toast.makeText(activity, "TTS Error", Toast.LENGTH_SHORT).show();
                            onSpeakStopped();
                        });

                    }



                });

                ttsSpeak(text);


            } else {
                Toast.makeText(activity, "TTS Error", Toast.LENGTH_SHORT).show();
            }
        });


    }



    private void ttsSpeak(String text) {
        int maxLength = 3000; // Maximum length of text that can be spoken at once;

        // Split the text if it's too long
        if (text.length() > maxLength) {
            // Speak the first chunk and flush the queue
            int splitPoint = text.lastIndexOf('.', maxLength);
            if (splitPoint == -1) {
                // If no space is found (i.e., the word is longer than maxLength), split at maxLength
                splitPoint = maxLength;
            }

            String firstChunk = text.substring(0, splitPoint); // Get the first chunk
            textToSpeech.speak(firstChunk, TextToSpeech.QUEUE_FLUSH, null, System.currentTimeMillis() + "");

            text = text.substring(splitPoint).trim(); // Remove the first chunk from the text

            // Speak the remaining chunks
            while (text.length() > maxLength) {
                splitPoint = text.lastIndexOf('.', maxLength);
                if (splitPoint == -1) {
                    splitPoint = maxLength;
                }

                String chunk = text.substring(0, splitPoint); // Get the next chunk
                textToSpeech.speak(chunk, TextToSpeech.QUEUE_ADD, null, System.currentTimeMillis() + "");
                text = text.substring(splitPoint).trim(); // Remove the chunk from the text
            }

            // Speak the final remaining part
            if (!text.isEmpty()) {
                textToSpeech.speak(text, TextToSpeech.QUEUE_ADD, null, System.currentTimeMillis() + "");
            }
        } else {
            // Speak the entire text at once if it's within the limit, flushing the queue
            textToSpeech.speak(text, TextToSpeech.QUEUE_FLUSH, null, System.currentTimeMillis() + "");
        }
    }



    private void onSpeakStarted(){
        progress_tts.setVisibility(View.GONE);
        iv_tts.setVisibility(View.VISIBLE);
        iv_tts.setImageResource(R.drawable.ic_mic_off);
        iv_tts.setOnClickListener(v -> {
            if(textToSpeech != null) textToSpeech.shutdown();
            onSpeakStopped();
        });



        AudioManager audioManager = (AudioManager) activity.getSystemService(Context.AUDIO_SERVICE);
        int currentVolume = audioManager.getStreamVolume(AudioManager.STREAM_MUSIC);
        int maxVolume = audioManager.getStreamMaxVolume(AudioManager.STREAM_MUSIC);
        if (currentVolume < (0.3 * maxVolume)) audioManager.adjustVolume(AudioManager.ADJUST_SAME, AudioManager.FLAG_SHOW_UI);







    }



    private void onSpeakStopped(){
        progress_tts.setVisibility(View.GONE);
        iv_tts.setVisibility(View.VISIBLE);
        iv_tts.setImageResource(R.drawable.ic_mic);
        iv_tts.setOnClickListener(v -> initializeTTS(Html.fromHtml(post.getContent(), Html.FROM_HTML_MODE_LEGACY).toString()));
    }



    public void removeDuplicateIMG(Document document, String imageUrl) {
        Log.d("POST_IMAGE", imageUrl);
        Elements imgTags = document.select("img");
        String imageUrl1 = removeExtension(imageUrl);
        for (Element imgTag : imgTags) {
            String imageUrl2 = imgTag.attr("src");
            Log.d("CONTENT_IMAGE", imageUrl2);
            imageUrl2 = removeExtension(imageUrl2);
            if(imageUrl1.length()>imageUrl2.length()){
                imageUrl1 = removeLastSegment(imageUrl1);
                if(imageUrl2.length()>imageUrl1.length()) imageUrl2 = removeLastSegment(imageUrl2);
            }else if(imageUrl2.length()>imageUrl1.length()){
                imageUrl2 = removeLastSegment(imageUrl2);
                if(imageUrl1.length()>imageUrl2.length()) imageUrl1 = removeLastSegment(imageUrl1);
            }
            Log.d("POST_IMAGE_MODIFIED", imageUrl1);
            Log.d("CONTENT_IMAGE_MODIFIED", imageUrl2);
            if (imageUrl1.equals(imageUrl2)) {
                imgTag.remove();
            }
        }
    }
    private String removeExtension(String imageUrl){
        int lastDotIndex = imageUrl.lastIndexOf(".");
        if (lastDotIndex != -1) return imageUrl.substring(0, lastDotIndex);
        return imageUrl;
    }
    private String removeLastSegment(String imageUrl) {
        int lastDash = imageUrl.lastIndexOf("-");
        int lastUnderscore = imageUrl.lastIndexOf("_");
        if (lastDash > lastUnderscore) return imageUrl.substring(0, lastDash);
        else if (lastUnderscore > lastDash) return imageUrl.substring(0, lastUnderscore);
        return imageUrl;
    }

    public boolean isViewVisible(NestedScrollView scrollView, View view) {
        Rect scrollBounds = new Rect();
        scrollView.getHitRect(scrollBounds);
        return view.getLocalVisibleRect(scrollBounds);
    }

    public void handleBackPress() {
        if(!isAnimating) {
            if(fullscreenContainer==null){
                if(!isViewVisible(nestedScrollView,iv_post)) {
                    setSharedElementEnterTransition(null);
                    setSharedElementReturnTransition(null);
                    setEnterTransition(null);
                    setExitTransition(null);
                }
                webView.destroy();
                activity.getSupportFragmentManager().popBackStack();
                if (isBookmarkRemoved & bookmarkRemovedCallback != null)
                    bookmarkRemovedCallback.onBookmarkRemoved();
            }
        }

    }



    @Override
    public void onDestroyView() {
        if(textToSpeech != null) textToSpeech.shutdown();
        super.onDestroyView();
    }





    public interface BookmarkRemovedCallback{

        void onBookmarkRemoved();

    }




}